﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Kinect;

namespace KinectCameraSample
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        // Kinectセンサーからの画像情報を受け取るバッファ
        private byte[] pixelBuffer = null;

        // 画面に表示するビットマップ
        private WriteableBitmap bmpBuffer = null;

        public MainWindow()
        {
            InitializeComponent();
        }

        private void WindowLoaded(object sender, RoutedEventArgs e)
        {
            // Kinectセンサーの取得(エラー処理など省略版)
            KinectSensor kinect = KinectSensor.KinectSensors[0];

            // カラーストリームの有効化
            kinect.ColorStream.Enable(ColorImageFormat.RgbResolution640x480Fps30);

            // バッファの初期化
            pixelBuffer = new byte[kinect.ColorStream.FramePixelDataLength];
            bmpBuffer = new WriteableBitmap(kinect.ColorStream.FrameWidth,
                                            kinect.ColorStream.FrameHeight,
                                            96, 96, PixelFormats.Bgr32, null);

            rgbImage.Source = bmpBuffer;

            // イベントハンドラの登録
            kinect.ColorFrameReady += ColorImageReady;

            // Kinectセンサーからのストリーム取得を開始
            kinect.Start();

        }

        private void ColorImageReady(object sender, ColorImageFrameReadyEventArgs e)
        {
            using (ColorImageFrame imageFrame = e.OpenColorImageFrame())
            {
                if (imageFrame != null)
                {
                    // 画像情報の幅・高さ取得　※途中で変わらない想定！
                    int frmWidth = imageFrame.Width;
                    int frmHeight = imageFrame.Height;

                    // 画像情報をバッファにコピー
                    imageFrame.CopyPixelDataTo(pixelBuffer);
                    // ビットマップに描画
                    Int32Rect src = new Int32Rect(0, 0, frmWidth, frmHeight);
                    bmpBuffer.WritePixels(src, pixelBuffer, frmWidth * 4, 0);

                }

            }
        }
    }
}
